/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.statue.requirement;

import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.api.statue.requirement.AbstractStatueRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class AbstractStringStatueRequirement
extends AbstractStatueRequirement<String> {
    protected String value;
    protected String defaultValue;

    protected AbstractStringStatueRequirement(Set<String> keys, String defaultValue) {
        super(keys);
        this.defaultValue = defaultValue;
    }

    protected AbstractStringStatueRequirement(Set<String> keys, String defaultValue, String value) {
        this(keys, defaultValue);
        this.value = value;
    }

    @Override
    public ParseAttempt<List<Requirement<Pokemon, StatueEntity, ?>>> create(String key, String spec) {
        if (!spec.startsWith(key + ":")) {
            return ParseAttempt.error("No key found!");
        }
        String[] args = spec.split(key + ":");
        String parsedValue = args.length > 0 ? args[1] : this.defaultValue;
        return this.createInstance(parsedValue).map(Collections::singletonList);
    }

    @Override
    public String getValue() {
        return this.value;
    }
}

