/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.statue.requirement;

import com.google.common.collect.Lists;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.api.statue.StatueSpecificationProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public abstract class AbstractRecursiveStatueRequirement
implements Requirement<Pokemon, StatueEntity, List<Requirement<Pokemon, StatueEntity, ?>>> {
    protected final Set<String> keys;
    protected List<Requirement<Pokemon, StatueEntity, ?>> requirements;

    protected AbstractRecursiveStatueRequirement(Set<String> keys) {
        this.keys = keys;
    }

    protected AbstractRecursiveStatueRequirement(Set<String> keys, List<Requirement<Pokemon, StatueEntity, ?>> requirements) {
        this(keys);
        this.requirements = requirements;
    }

    @Override
    public List<String> getAliases() {
        return Lists.newArrayList(this.keys);
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public boolean shouldContinue() {
        return false;
    }

    @Override
    public boolean fits(String spec) {
        for (String key : this.keys) {
            if (!spec.contains(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ParseAttempt<List<Requirement<Pokemon, StatueEntity, ?>>> create(String spec) {
        for (String key : this.keys) {
            if (!spec.contains(key)) continue;
            String[] args = spec.split(key);
            if (args.length == 0) {
                return ParseAttempt.error("Cannot find any data");
            }
            ArrayList requirements = Lists.newArrayList();
            for (String arg : args) {
                ParseAttempt<List<Requirement<Pokemon, StatueEntity, ?>>> parsedRequirements = StatueSpecificationProxy.requirements(arg);
                if (!parsedRequirements.wasSuccess()) {
                    return parsedRequirements;
                }
                requirements.addAll((Collection)parsedRequirements.get());
            }
            return ParseAttempt.success(requirements);
        }
        return ParseAttempt.error("Cannot find any data");
    }

    @Override
    public List<Requirement<Pokemon, StatueEntity, ?>> getValue() {
        return this.requirements;
    }
}

