/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.statue.requirement;

import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.api.statue.requirement.AbstractStatueRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class AbstractIntegerStatueRequirement
extends AbstractStatueRequirement<Integer> {
    protected int value;
    protected int defaultValue;

    protected AbstractIntegerStatueRequirement(Set<String> keys, int defaultValue) {
        super(keys);
        this.defaultValue = defaultValue;
    }

    protected AbstractIntegerStatueRequirement(Set<String> keys, int defaultValue, int value) {
        this(keys, defaultValue);
        this.value = value;
    }

    @Override
    public ParseAttempt<List<Requirement<Pokemon, StatueEntity, ?>>> create(String key, String spec) {
        if (!spec.startsWith(key + ":")) {
            return ParseAttempt.error("No key found!");
        }
        String[] args = spec.split(key + ":");
        int parsedValue = args.length > 0 ? this.parseInt(args[1]) : this.defaultValue;
        return this.createInstance(parsedValue).map(Collections::singletonList);
    }

    private int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return this.defaultValue;
        }
    }

    @Override
    public Integer getValue() {
        return this.value;
    }
}

