/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.statue;

import com.pixelmonmod.api.AbstractSpecification;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.api.statue.StatueSpecificationProxy;
import com.pixelmonmod.pixelmon.api.pokemon.InitializeCategory;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import java.util.List;
import java.util.UUID;
import net.minecraft.world.level.Level;

public class StatueSpecification
extends AbstractSpecification<Pokemon, StatueEntity> {
    public StatueSpecification(String originalSpec, List<Requirement<Pokemon, StatueEntity, ?>> requirements) {
        super(Pokemon.class, StatueEntity.class, originalSpec, requirements);
    }

    public StatueSpecification clone() {
        return StatueSpecificationProxy.create(this.originalSpec).get();
    }

    @Override
    public Pokemon create() {
        return this.create(false);
    }

    @Override
    public Pokemon create(boolean shallow) {
        Pokemon pokemon = PokemonFactory.create(UUID.randomUUID());
        for (Requirement requirement : this.requirements) {
            requirement.applyData(pokemon);
        }
        if (this.requirements.isEmpty()) {
            pokemon.setSpecies(PixelmonSpecies.MISSINGNO.getValueUnsafe(), true);
        }
        if (!shallow) {
            pokemon.initialize(InitializeCategory.EMPTY);
        }
        return pokemon;
    }

    public StatueEntity create(Level world) {
        StatueEntity entity = new StatueEntity(world);
        entity.setPokemon(this.create());
        for (Requirement requirement : this.requirements) {
            requirement.applyMinecraft(entity);
        }
        return entity;
    }
}

