/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.requirement;

import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.requirement.AbstractRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class AbstractStringRequirement<A, B>
extends AbstractRequirement<A, B, String> {
    protected String value;
    protected final String defaultValue;

    protected AbstractStringRequirement(Set<String> keys, String defaultValue) {
        super(keys);
        this.defaultValue = defaultValue;
    }

    protected AbstractStringRequirement(Set<String> keys, String defaultValue, String value) {
        this(keys, defaultValue);
        this.value = value;
    }

    @Override
    public ParseAttempt<List<Requirement<A, B, ?>>> create(String key, String spec) {
        if (!spec.startsWith(key + ":")) {
            return ParseAttempt.error("No key found " + key);
        }
        String[] args = spec.split(key + ":");
        String calculatedValue = args.length > 0 ? args[1] : this.defaultValue;
        ParseAttempt instance = this.createInstance(calculatedValue);
        return instance.map(Collections::singletonList);
    }

    @Override
    public String getValue() {
        return this.value;
    }
}

