/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.requirement;

import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.requirement.AbstractRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class AbstractIntegerRequirement<A, B>
extends AbstractRequirement<A, B, Integer> {
    protected int value;
    protected int defaultValue;

    protected AbstractIntegerRequirement(Set<String> keys, int defaultValue) {
        super(keys);
        this.defaultValue = defaultValue;
    }

    protected AbstractIntegerRequirement(Set<String> keys, int defaultValue, int value) {
        this(keys, defaultValue);
        this.value = value;
    }

    @Override
    public ParseAttempt<List<Requirement<A, B, ?>>> create(String key, String spec) {
        if (!spec.startsWith(key + ":")) {
            return ParseAttempt.error("No key found " + key);
        }
        String[] args = spec.split(key + ":");
        int parsedValue = args.length > 0 ? this.parseInt(args[1]) : this.defaultValue;
        return this.createInstance(parsedValue).map(Collections::singletonList);
    }

    private int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return this.defaultValue;
        }
    }

    @Override
    public Integer getValue() {
        return this.value;
    }
}

