/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.requirement;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.requirement.AbstractRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public abstract class AbstractBooleanRequirement<A, B>
extends AbstractRequirement<A, B, Boolean> {
    private static final Set<String> FALSE_IDENTIFIERS = Sets.newHashSet((Object[])new String[]{"0", "false"});
    private static final Set<String> TRUE_IDENTIFIERS = Sets.newHashSet((Object[])new String[]{"1", "true"});
    protected boolean value;

    protected AbstractBooleanRequirement(Set<String> keys) {
        super(keys);
    }

    protected AbstractBooleanRequirement(Set<String> keys, boolean value) {
        super(keys);
        this.value = value;
    }

    @Override
    public ParseAttempt<List<Requirement<A, B, ?>>> create(String key, String spec) {
        if (spec.equalsIgnoreCase(key)) {
            return this.createInstance(true).map(Collections::singletonList);
        }
        if (!spec.startsWith(key + ":")) {
            return ParseAttempt.error("No key found " + key);
        }
        String[] args = spec.split(key + ":");
        boolean invert = args.length > 0 && args[0].startsWith("!") || spec.startsWith("!");
        boolean parsedValue = args.length > 0 && this.parseBoolean(args[1]);
        return this.createInstance(invert != parsedValue).map(Collections::singletonList);
    }

    protected boolean parseBoolean(String s) {
        if (s == null || FALSE_IDENTIFIERS.contains(s.toLowerCase(Locale.ROOT))) {
            return false;
        }
        return TRUE_IDENTIFIERS.contains(s.toLowerCase(Locale.ROOT));
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }
}

