/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.registry;

import com.pixelmonmod.api.registry.RegistryManager;
import com.pixelmonmod.pixelmon.api.util.helpers.StringHelper;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class RegistryValue<T> {
    private final String key;
    private T value;
    private boolean initialized = false;

    public static <T> RegistryValue<T> of(Class<T> type, String key) {
        return RegistryValue.of(type, key, null);
    }

    public static <T> RegistryValue<T> of(Class<T> type, String key, T value) {
        return RegistryManager.getRegistry(type).setValue(key, value);
    }

    public static <T> Optional<RegistryValue<T>> get(Class<T> type, String key) {
        return RegistryManager.getRegistry(type).get(key);
    }

    protected RegistryValue(String key) {
        this(key, null);
    }

    protected RegistryValue(String key, T value) {
        this.key = StringHelper.toID(key);
        this.setValue(value);
    }

    protected RegistryValue<T> setValue(T value) {
        if (!this.isInitialized() && value != null) {
            this.value = value;
            this.initialized = true;
        }
        return this;
    }

    public RegistryValue<T> invalidate() {
        this.initialized = false;
        this.value = null;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void ifPresent(Consumer<T> consumer) {
        this.ifInitialized(consumer);
    }

    public void ifInitialized(Consumer<T> consumer) {
        if (this.isInitialized()) {
            consumer.accept(this.value);
        }
    }

    public Optional<T> getValue() {
        return Optional.ofNullable(this.value);
    }

    @Deprecated
    public T get() {
        return this.getValueUnsafe();
    }

    public T getValueUnsafe() {
        return this.value;
    }

    public T orElse(Object other) {
        return (T)(this.isInitialized() ? this.value : other);
    }

    public T orElse(RegistryValue<T> other) {
        return this.isInitialized() ? this.value : other.getValueUnsafe();
    }

    public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isInitialized()) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(this.value));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegistryValue)) {
            return false;
        }
        RegistryValue that = (RegistryValue)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

