/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.registry;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.util.helpers.StringHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RegistryManager {
    private static final Map<Class<?>, Registry<?>> REGISTRIES = Maps.newHashMap();

    protected static <T> Registry<T> getRegistry(Class<?> type) {
        return REGISTRIES.computeIfAbsent(type, t -> new Registry());
    }

    public static <T> void register(String key, T value) {
        RegistryManager.register(key, value, value.getClass());
    }

    public static <T> void register(String key, T value, Class<T> clazz) {
        RegistryManager.getRegistry(clazz).setValue(key, value);
    }

    public static <T> RegistryValue<T> getRegistryValue(T value) {
        return RegistryManager.getRegistry(value.getClass()).getKeyForValue(value);
    }

    public static <T> List<T> getAllValues(Class<T> type) {
        ArrayList all = Lists.newArrayList();
        for (RegistryValue<Object> registryValue : RegistryManager.getRegistry(type).getAll()) {
            registryValue.ifInitialized(o -> all.add(o));
        }
        return all;
    }

    public static List<String> getAllKeys(Class<?> type) {
        return ImmutableList.copyOf(RegistryManager.getRegistry(type).getAllKeys());
    }

    public static void invalidateRegistry(Class<?> type) {
    }

    protected static class Registry<T> {
        private final Map<String, RegistryValue<T>> keyMap = Maps.newHashMap();
        private final Map<T, RegistryValue<T>> valueMap = Maps.newHashMap();

        protected Registry() {
        }

        public RegistryValue<T> createOrGetValue(String key) {
            return this.keyMap.computeIfAbsent(StringHelper.toID(key), RegistryValue::new);
        }

        public RegistryValue<T> setValue(String key, T value) {
            RegistryValue<T> holder = this.createOrGetValue(StringHelper.toID(key)).setValue(value);
            this.valueMap.put(value, holder);
            return holder;
        }

        public Optional<RegistryValue<T>> get(String key) {
            return Optional.ofNullable(this.keyMap.get(StringHelper.toID(key)));
        }

        private RegistryValue<T> getKeyForValue(T value) {
            return this.valueMap.get(value);
        }

        private Collection<RegistryValue<T>> getAll() {
            return this.keyMap.values();
        }

        private Collection<String> getAllKeys() {
            return this.keyMap.keySet();
        }
    }
}

