/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl.shader;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.requirement.AbstractStringPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.render.shader.ShaderParameters;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class ShaderRequirement
extends AbstractStringPokemonRequirement {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"shader"});
    private static final String DEFAULT_VALUE = "none";

    public ShaderRequirement() {
        super(KEYS, DEFAULT_VALUE);
    }

    public ShaderRequirement(String value) {
        super(KEYS, DEFAULT_VALUE, value);
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, PixelmonEntity, String>> createInstance(String value) {
        ResourceLocation path = ResourceLocationHelper.of(value);
        if (path == null) {
            return ParseAttempt.error("Invalid shader: " + value);
        }
        return ParseAttempt.success(new ShaderRequirement(value));
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return false;
    }

    @Override
    public boolean isMinecraftMatch(PixelmonEntity entity) {
        return false;
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        pixelmon.getPersistentData().m_128359_("SHADER", this.value);
    }

    @Override
    public void applyMinecraft(PixelmonEntity entity) {
        this.applyData(entity.getPokemon());
        entity.setShaderParameters(ShaderParameters.builder().full().texture().onlyShader().id(ResourceLocationHelper.of(this.value)).build());
    }
}

