/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl.friendship;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.requirement.AbstractIntegerPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Set;

public class MinimumFriendshipRequirement
extends AbstractIntegerPokemonRequirement {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"minfriendship"});
    private static final int DEFAULT_VALUE = 1;

    public MinimumFriendshipRequirement() {
        super(KEYS, 1);
    }

    public MinimumFriendshipRequirement(int value) {
        super(KEYS, 1, value);
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, PixelmonEntity, Integer>> createInstance(Integer value) {
        if (value > 255) {
            return ParseAttempt.error("Friendship cannot be greater than 255");
        }
        return ParseAttempt.success(new MinimumFriendshipRequirement(value));
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return pixelmon.getFriendship() >= this.value;
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        pixelmon.setFriendship(RandomHelper.getRandomNumberBetween(this.value, 255));
    }
}

