/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.NumberHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.StringHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class TypeRequirement
implements Requirement<Pokemon, PixelmonEntity, Pair<Integer, Element>> {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"type"});
    private int pos;
    private Element element;

    public TypeRequirement() {
    }

    public TypeRequirement(int pos, Element element) {
        this.pos = pos;
        this.element = element;
    }

    public TypeRequirement(Pair<Integer, Element> data) {
        this((Integer)data.getFirst(), (Element)data.getSecond());
    }

    @Override
    public List<String> getAliases() {
        return Lists.newArrayList(KEYS);
    }

    @Override
    public boolean fits(String spec) {
        for (String key : KEYS) {
            if (!spec.contains(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ParseAttempt<List<Requirement<Pokemon, PixelmonEntity, ?>>> create(String spec) {
        for (String key : KEYS) {
            String[] afterKey;
            if (!spec.contains(key) || (afterKey = StringHelper.findValuesAfterKeyBeforeSpace(spec, key)) == null) continue;
            ArrayList requirements = Lists.newArrayList();
            for (String data : afterKey) {
                String[] args = data.split(":");
                int pos = NumberHelper.parseInt(args[0]).orElse(-1);
                if (pos > 2) {
                    return ParseAttempt.error("Invalid type id (" + pos + "). A Pokemon can only have 2 types");
                }
                Element element = Element.parseType(args[1]);
                if (element == null) {
                    return ParseAttempt.error("Invalid element: " + args[1]);
                }
                ParseAttempt<Requirement<Pokemon, PixelmonEntity, Pair<Integer, Element>>> instance = this.createInstance((Pair<Integer, Element>)Pair.of((Object)pos, (Object)element));
                if (!instance.wasSuccess()) {
                    return instance.map(requirement -> Collections.emptyList());
                }
                requirements.add(instance.get());
            }
            return ParseAttempt.success(requirements);
        }
        return ParseAttempt.error("Cannot find key");
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, PixelmonEntity, Pair<Integer, Element>>> createInstance(Pair<Integer, Element> value) {
        return ParseAttempt.success(new TypeRequirement(value));
    }

    @Override
    public boolean isMinecraftMatch(PixelmonEntity entity) {
        return this.isDataMatch(entity.getPokemon());
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        if (this.pos == -1) {
            return pixelmon.getForm().getTypes().contains(this.element);
        }
        return Objects.equals(pixelmon.getForm().getTypes().get(this.pos - 1), this.element);
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        pixelmon.setSpecies(PixelmonSpecies.getRandomFromType(this.element).orElse(pixelmon.getSpecies()), true);
    }

    @Override
    public void applyMinecraft(PixelmonEntity entity) {
        this.applyData(entity.getPokemon());
    }

    @Override
    public Pair<Integer, Element> getValue() {
        return Pair.of((Object)this.pos, (Object)this.element);
    }
}

