/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.requirement.AbstractStringPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.status.Burn;
import com.pixelmonmod.pixelmon.battles.status.Drowsy;
import com.pixelmonmod.pixelmon.battles.status.Freeze;
import com.pixelmonmod.pixelmon.battles.status.Frostbite;
import com.pixelmonmod.pixelmon.battles.status.NoStatus;
import com.pixelmonmod.pixelmon.battles.status.Paralysis;
import com.pixelmonmod.pixelmon.battles.status.Poison;
import com.pixelmonmod.pixelmon.battles.status.PoisonBadly;
import com.pixelmonmod.pixelmon.battles.status.Sleep;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Locale;
import java.util.Set;

public class StatusRequirement
extends AbstractStringPokemonRequirement {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"status"});
    private static final String DEFAULT_VALUE = "none";

    public StatusRequirement() {
        super(KEYS, DEFAULT_VALUE);
    }

    public StatusRequirement(String value) {
        super(KEYS, DEFAULT_VALUE, value);
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, PixelmonEntity, String>> createInstance(String value) {
        return ParseAttempt.success(new StatusRequirement(value));
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return StatusRequirement.getStatus((String)this.value).type == pixelmon.getStatus().type;
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        pixelmon.setStatus(StatusRequirement.getStatus(this.value));
    }

    private static StatusPersist getStatus(String name) {
        switch (name.toLowerCase(Locale.ROOT)) {
            case "sleep": {
                return new Sleep();
            }
            case "burn": {
                return new Burn();
            }
            case "paralyzed": 
            case "paralysis": {
                return new Paralysis();
            }
            case "frozen": 
            case "freeze": {
                return new Freeze();
            }
            case "poison": {
                return new Poison();
            }
            case "poisonbadly": 
            case "poison badly": {
                return new PoisonBadly();
            }
            case "drowsy": {
                return new Drowsy();
            }
            case "frostbite": 
            case "frostbitten": {
                return new Frostbite();
            }
        }
        return NoStatus.noStatus;
    }
}

