/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.requirement.AbstractIntegerPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class StatsRequirement
extends AbstractIntegerPokemonRequirement {
    private static final Map<BattleStatsType, Set<String>> KEYS_BY_STAT = Maps.newHashMap();
    private static final int DEFAULT_VALUE = 0;
    private final BattleStatsType statType;

    public StatsRequirement(BattleStatsType statType) {
        super(KEYS_BY_STAT.get(statType), 0);
        this.statType = statType;
    }

    public StatsRequirement(BattleStatsType statType, int value) {
        super(KEYS_BY_STAT.get(statType), 0, value);
        this.statType = statType;
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, PixelmonEntity, Integer>> createInstance(Integer value) {
        return ParseAttempt.success(new StatsRequirement(this.statType, (int)value));
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return Objects.equals(pixelmon.getStats().get(this.statType), this.value);
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        pixelmon.getStats().set(this.statType, this.value);
    }

    static {
        KEYS_BY_STAT.put(BattleStatsType.HP, Sets.newHashSet((Object[])new String[]{"hp"}));
        KEYS_BY_STAT.put(BattleStatsType.ATTACK, Sets.newHashSet((Object[])new String[]{"attack", "atk"}));
        KEYS_BY_STAT.put(BattleStatsType.DEFENSE, Sets.newHashSet((Object[])new String[]{"defence", "defense", "def"}));
        KEYS_BY_STAT.put(BattleStatsType.SPECIAL_ATTACK, Sets.newHashSet((Object[])new String[]{"specialattack", "spatk"}));
        KEYS_BY_STAT.put(BattleStatsType.SPECIAL_DEFENSE, Sets.newHashSet((Object[])new String[]{"specialdefence", "specialdefense", "spdef"}));
        KEYS_BY_STAT.put(BattleStatsType.SPEED, Sets.newHashSet((Object[])new String[]{"speed", "spd"}));
    }
}

