/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.requirement.AbstractBooleanPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.ShearableStats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Set;

public class ShornRequirement
extends AbstractBooleanPokemonRequirement {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"shorn", "isshorn"});

    public ShornRequirement() {
        super(KEYS);
    }

    public ShornRequirement(boolean value) {
        super(KEYS, value);
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, PixelmonEntity, Boolean>> createInstance(Boolean value) {
        return ParseAttempt.success(new ShornRequirement(value));
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        if (!pixelmon.getSpecies().is(PixelmonSpecies.WOOLOO, PixelmonSpecies.MAREEP, PixelmonSpecies.DUBWOOL)) {
            return false;
        }
        ShearableStats stats = pixelmon.getExtraStats(ShearableStats.class).orElse(null);
        if (stats == null) {
            return false;
        }
        return stats.growthStage > 0;
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        if (!pixelmon.getSpecies().is(PixelmonSpecies.WOOLOO, PixelmonSpecies.MAREEP, PixelmonSpecies.DUBWOOL)) {
            return;
        }
        ShearableStats stats = pixelmon.getExtraStats(ShearableStats.class).orElse(null);
        if (stats == null) {
            return;
        }
        stats.growthStage = (byte)10;
    }
}

