/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.requirement.AbstractPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.Ribbon;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.RibbonRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.type.RibbonType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.network.chat.Component;

public class RibbonRequirement
extends AbstractPokemonRequirement<List<Ribbon>> {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"ribbon", "ribbons"});
    private static final List<Ribbon> NONE = Lists.newArrayList();
    private List<Ribbon> ribbons;

    public RibbonRequirement() {
        super(KEYS);
    }

    public RibbonRequirement(List<Ribbon> ribbons) {
        this();
        this.ribbons = ribbons;
    }

    @Override
    public ParseAttempt<List<Requirement<Pokemon, PixelmonEntity, ?>>> create(String key, String spec) {
        if (!spec.startsWith(key + ":")) {
            return ParseAttempt.error("No key found");
        }
        String[] args = spec.split(key + ":");
        if (args.length < 2) {
            return this.createInstance(NONE).map(Collections::singletonList);
        }
        ArrayList ribbons = Lists.newArrayList();
        for (String name : args[1].split(",")) {
            RibbonType ribbonType = RibbonRegistry.getRibbon(name).getValueUnsafe();
            if (ribbonType == null) {
                return ParseAttempt.error("Invalid ribbon " + name);
            }
            ribbons.add(Ribbon.builder().type(ribbonType).receivedDate(System.currentTimeMillis()).receiver((Component)Component.m_237119_()).build());
        }
        if (ribbons.isEmpty()) {
            return this.createInstance(NONE).map(Collections::singletonList);
        }
        return this.createInstance(ribbons).map(Collections::singletonList);
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, PixelmonEntity, List<Ribbon>>> createInstance(List<Ribbon> value) {
        return ParseAttempt.success(new RibbonRequirement(value));
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return this.ribbons.equals(pixelmon.getRibbons());
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        for (Ribbon ribbon : this.ribbons) {
            ribbon.refreshData(pixelmon);
        }
        for (Ribbon ribbon : this.ribbons) {
            pixelmon.addRibbon(ribbon);
        }
    }

    @Override
    public List<Ribbon> getValue() {
        return this.ribbons;
    }
}

