/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.requirement.AbstractBooleanPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.EVStore;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Set;

public class ResetEVsRequirement
extends AbstractBooleanPokemonRequirement {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"resetevs"});

    public ResetEVsRequirement() {
        super(KEYS);
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, PixelmonEntity, Boolean>> createInstance(Boolean value) {
        return ParseAttempt.success(new ResetEVsRequirement());
    }

    @Override
    public boolean isDataMatch(Pokemon pokemon) {
        return pokemon.getEVs().getTotal() == 0;
    }

    @Override
    public void applyData(Pokemon pokemon) {
        EVStore stat = pokemon.getEVs();
        stat.setStat(BattleStatsType.HP, 0);
        stat.setStat(BattleStatsType.ATTACK, 0);
        stat.setStat(BattleStatsType.DEFENSE, 0);
        stat.setStat(BattleStatsType.SPECIAL_ATTACK, 0);
        stat.setStat(BattleStatsType.SPECIAL_DEFENSE, 0);
        stat.setStat(BattleStatsType.SPEED, 0);
    }
}

