/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Lists;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Collections;
import java.util.List;

public class RandomSpeciesRequirement
implements Requirement<Pokemon, PixelmonEntity, PokemonSpecification> {
    private static final List<String> KEYS = Lists.newArrayList((Object[])new String[]{"random", "randomspecies"});
    protected PokemonSpecification spec;

    public RandomSpeciesRequirement() {
    }

    public RandomSpeciesRequirement(PokemonSpecification spec) {
        this.spec = spec;
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, PixelmonEntity, PokemonSpecification>> createInstance(PokemonSpecification value) {
        return ParseAttempt.success(new RandomSpeciesRequirement(value));
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public boolean shouldContinue() {
        return false;
    }

    @Override
    public List<String> getAliases() {
        return KEYS;
    }

    @Override
    public boolean fits(String spec) {
        for (String key : KEYS) {
            if (!spec.startsWith(key)) continue;
            if (spec.length() == key.length()) {
                return true;
            }
            String remainingSpec = spec.substring(key.length() + 1);
            if (remainingSpec.isEmpty()) {
                return true;
            }
            if (!spec.contains(key + " ")) continue;
            return true;
        }
        return false;
    }

    @Override
    public ParseAttempt<List<Requirement<Pokemon, PixelmonEntity, ?>>> create(String spec) {
        for (String key : KEYS) {
            if (!spec.startsWith(key)) continue;
            if (spec.length() == key.length()) {
                return this.createInstance(null).map(Collections::singletonList);
            }
            if (!spec.contains(key + " ")) continue;
            String remainingSpec = spec.substring(key.length() + 1);
            if (remainingSpec.isEmpty()) {
                return this.createInstance(null).map(Collections::singletonList);
            }
            if (this.fits(remainingSpec)) {
                return ParseAttempt.error("You cannot have a random followed by a random");
            }
            ParseAttempt<PokemonSpecification> parseAttempt = PokemonSpecificationProxy.create(remainingSpec);
            if (!parseAttempt.wasSuccess()) {
                return parseAttempt.map(pokemonSpecification -> Collections.emptyList());
            }
            return this.createInstance(parseAttempt.get()).map(Collections::singletonList);
        }
        return ParseAttempt.error("Cannot find any data");
    }

    @Override
    public boolean isMinecraftMatch(PixelmonEntity entity) {
        return this.spec == null || this.spec.matches((Object)entity);
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return this.spec == null || this.spec.matches(pixelmon);
    }

    @Override
    public void applyMinecraft(PixelmonEntity pixelmonEntity) {
        pixelmonEntity.getPokemon().setSpecies(PixelmonSpecies.getRandomSpecies(), false);
        if (this.spec != null) {
            this.spec.apply((Object)pixelmonEntity);
        }
        for (int counter = 0; this.spec != null && !this.spec.matches((Object)pixelmonEntity) && counter <= 250; ++counter) {
            pixelmonEntity.getPokemon().setSpecies(PixelmonSpecies.getRandomSpecies(), false);
            this.spec.apply((Object)pixelmonEntity);
        }
    }

    @Override
    public PokemonSpecification getValue() {
        return this.spec;
    }

    @Override
    public void applyData(Pokemon pokemon) {
        pokemon.setSpecies(PixelmonSpecies.getRandomSpecies(), false);
        if (this.spec != null) {
            this.spec.apply(pokemon);
        }
        for (int counter = 0; this.spec != null && !this.spec.matches(pokemon) && counter <= 250; ++counter) {
            pokemon.setSpecies(PixelmonSpecies.getRandomSpecies(), false);
            this.spec.apply(pokemon);
        }
    }
}

