/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.requirement.AbstractBooleanPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Set;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class PrimalEvolutionRequirement
extends AbstractBooleanPokemonRequirement {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"canprimalevo", "canprimal", "canprimalrevert", "canprimalevolve"});

    public PrimalEvolutionRequirement() {
        super(KEYS);
    }

    public PrimalEvolutionRequirement(boolean value) {
        super(KEYS, value);
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, PixelmonEntity, Boolean>> createInstance(Boolean value) {
        return ParseAttempt.success(new PrimalEvolutionRequirement(value));
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        if (pixelmon.getSpecies().is(PixelmonSpecies.GROUDON)) {
            return pixelmon.getForm().isForm("primal") || pixelmon.getHeldItemAsItemHeld() == PixelmonItems.red_orb;
        }
        if (pixelmon.getSpecies().is(PixelmonSpecies.KYOGRE)) {
            return pixelmon.getForm().isForm("primal") || pixelmon.getHeldItemAsItemHeld() == PixelmonItems.blue_orb;
        }
        return false;
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        if (!pixelmon.getSpecies().is(PixelmonSpecies.GROUDON, PixelmonSpecies.KYOGRE)) {
            pixelmon.setSpecies(RandomHelper.getRandomElementFromArray(PixelmonSpecies.GROUDON, PixelmonSpecies.KYOGRE), true);
        }
        if (pixelmon.getSpecies().is(PixelmonSpecies.GROUDON)) {
            pixelmon.setHeldItem(new ItemStack((ItemLike)PixelmonItems.red_orb));
        } else {
            pixelmon.setHeldItem(new ItemStack((ItemLike)PixelmonItems.blue_orb));
        }
    }
}

