/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.requirement.AbstractPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokerusStrain;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Pokerus;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class PokerusRequirement
extends AbstractPokemonRequirement<PokerusStrain> {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"pokerus", "pkrs"});
    private PokerusStrain pokerus;

    public PokerusRequirement() {
        super(KEYS);
    }

    public PokerusRequirement(PokerusStrain pokerus) {
        this();
        this.pokerus = pokerus;
    }

    @Override
    public ParseAttempt<List<Requirement<Pokemon, PixelmonEntity, ?>>> create(String key, String spec) {
        if (!spec.startsWith(key + ":")) {
            return ParseAttempt.error("No key found");
        }
        String[] args = spec.split(key + ":");
        if (args.length == 0) {
            return this.createInstance(PokerusStrain.UNINFECTED).map(Collections::singletonList);
        }
        PokerusStrain strain = PokerusStrain.valueOf(args[1].toUpperCase());
        if (strain == null) {
            return ParseAttempt.error("Invalid pokerus strain " + args[1]);
        }
        return this.createInstance(strain).map(Collections::singletonList);
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, PixelmonEntity, PokerusStrain>> createInstance(PokerusStrain value) {
        return ParseAttempt.success(new PokerusRequirement(value));
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return Objects.equals((Object)pixelmon.getPokerus().type, (Object)this.pokerus);
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        pixelmon.setPokerus(new Pokerus(this.pokerus));
    }

    @Override
    public PokerusStrain getValue() {
        return this.pokerus;
    }
}

