/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.requirement.AbstractPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class PokeBallRequirement
extends AbstractPokemonRequirement<PokeBall> {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"ball", "ba"});
    private PokeBall ball;

    public PokeBallRequirement() {
        super(KEYS);
    }

    public PokeBallRequirement(PokeBall ball) {
        this();
        this.ball = ball;
    }

    @Override
    public ParseAttempt<List<Requirement<Pokemon, PixelmonEntity, ?>>> create(String key, String spec) {
        if (!spec.startsWith(key + ":")) {
            return ParseAttempt.error("No key found");
        }
        String[] args = spec.split(key + ":");
        if (args.length == 0) {
            return this.createInstance(PokeBallRegistry.POKE_BALL.orElse((Object)null)).map(Collections::singletonList);
        }
        PokeBall parsedBall = PokeBallRegistry.getPokeBall(args[1]).orElse((Object)null);
        if (parsedBall == null) {
            return ParseAttempt.error("Cannot find ball with id " + args[1]);
        }
        return this.createInstance(parsedBall).map(Collections::singletonList);
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, PixelmonEntity, PokeBall>> createInstance(PokeBall value) {
        return ParseAttempt.success(new PokeBallRequirement(value));
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return Objects.equals(pixelmon.getBall(), this.ball);
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        if (this.ball == null) {
            return;
        }
        pixelmon.setBall(this.ball);
    }

    @Override
    public PokeBall getValue() {
        return this.ball;
    }
}

