/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.requirement.AbstractPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Nature;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class NatureRequirement
extends AbstractPokemonRequirement<Nature> {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"nature", "n"});
    private Nature nature;

    public NatureRequirement() {
        super(KEYS);
    }

    public NatureRequirement(Nature nature) {
        this();
        this.nature = nature;
    }

    @Override
    public ParseAttempt<List<Requirement<Pokemon, PixelmonEntity, ?>>> create(String key, String spec) {
        if (!spec.startsWith(key + ":")) {
            return ParseAttempt.error("No key found");
        }
        String[] args = spec.split(key + ":");
        if (args.length == 0 || args.length == 1) {
            return this.createInstance(Nature.ADAMANT).map(Collections::singletonList);
        }
        Nature parsedNature = Nature.natureFromString(args[1]);
        if (parsedNature == null) {
            return ParseAttempt.error("Invalid nature");
        }
        return this.createInstance(parsedNature).map(Collections::singletonList);
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, PixelmonEntity, Nature>> createInstance(Nature value) {
        return ParseAttempt.success(new NatureRequirement(value));
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return Objects.equals(pixelmon.getNature(), this.nature);
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        pixelmon.setNature(this.nature);
    }

    @Override
    public Nature getValue() {
        return this.nature;
    }
}

