/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.requirement.AbstractIntegerPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Set;

public class MinimumLevelRequirement
extends AbstractIntegerPokemonRequirement {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"minlvl", "minlevel", "gtlvl"});
    private static final int DEFAULT_VALUE = 1;

    public MinimumLevelRequirement() {
        super(KEYS, 1);
    }

    public MinimumLevelRequirement(int value) {
        super(KEYS, 1, value);
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, PixelmonEntity, Integer>> createInstance(Integer value) {
        return ParseAttempt.success(new MinimumLevelRequirement(value));
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return pixelmon.getPokemonLevel() >= this.value;
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        pixelmon.setLevel(RandomHelper.getRandomNumberBetween(this.value, PixelmonConfigProxy.getGeneral().getMaxLevel()));
    }
}

