/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.requirement.AbstractIntegerPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.LakeTrioStats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Set;

public class LakeTrioRequirement
extends AbstractIntegerPokemonRequirement {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"enchanted", "enchantedcount", "laketrioenchanted"});
    private static final int DEFAULT_VALUE = 0;

    public LakeTrioRequirement() {
        super(KEYS, 0);
    }

    public LakeTrioRequirement(int value) {
        super(KEYS, 0, value);
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, PixelmonEntity, Integer>> createInstance(Integer value) {
        return ParseAttempt.success(new LakeTrioRequirement(value));
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        if (!pixelmon.getSpecies().is(PixelmonSpecies.AZELF, PixelmonSpecies.MESPRIT, PixelmonSpecies.UXIE)) {
            return false;
        }
        LakeTrioStats stats = pixelmon.getExtraStats(LakeTrioStats.class).orElse(null);
        if (stats == null) {
            return false;
        }
        return stats.numEnchanted == this.value;
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        if (!pixelmon.getSpecies().is(PixelmonSpecies.AZELF, PixelmonSpecies.MESPRIT, PixelmonSpecies.UXIE)) {
            return;
        }
        LakeTrioStats stats = pixelmon.getExtraStats(LakeTrioStats.class).orElse(null);
        if (stats == null) {
            return;
        }
        stats.numEnchanted = this.value;
    }
}

