/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.requirement.AbstractPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.items.HeldItem;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class HeldItemRequirement
extends AbstractPokemonRequirement<HeldItem> {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"helditem", "hi"});
    private HeldItem heldItem;

    public HeldItemRequirement() {
        super(KEYS);
    }

    public HeldItemRequirement(HeldItem heldItem) {
        this();
        this.heldItem = heldItem;
    }

    @Override
    public ParseAttempt<List<Requirement<Pokemon, PixelmonEntity, ?>>> create(String key, String spec) {
        if (!spec.startsWith(key + ":")) {
            return ParseAttempt.error("No key found");
        }
        String[] args = spec.split(key + ":");
        if (args.length == 0 || args.length == 1) {
            return ParseAttempt.error("No item found");
        }
        String rs = "pixelmon:" + args[1];
        Item item = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocationHelper.of(rs));
        if (item == null) {
            return ParseAttempt.error("Cannot find item by id " + rs);
        }
        if (!(item instanceof HeldItem)) {
            return ParseAttempt.error("Item is not a held item " + rs);
        }
        HeldItem heldItem = (HeldItem)item;
        return this.createInstance(heldItem).map(Collections::singletonList);
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, PixelmonEntity, HeldItem>> createInstance(HeldItem value) {
        return ParseAttempt.success(new HeldItemRequirement(value));
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return Objects.equals((Object)this.heldItem, pixelmon.getHeldItem().m_41720_());
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        pixelmon.setHeldItem(new ItemStack((ItemLike)this.heldItem));
    }

    @Override
    public HeldItem getValue() {
        return this.heldItem;
    }
}

