/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.requirement.AbstractStringPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Set;

public class HasSpecFlagRequirement
extends AbstractStringPokemonRequirement {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"specflag", "flag"});
    private static final String DEFAULT_VALUE = "untradeable";

    public HasSpecFlagRequirement() {
        super(KEYS, DEFAULT_VALUE);
    }

    public HasSpecFlagRequirement(String value) {
        super(KEYS, DEFAULT_VALUE, value);
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, PixelmonEntity, String>> createInstance(String value) {
        return ParseAttempt.success(new HasSpecFlagRequirement(value));
    }

    @Override
    public boolean isMinecraftMatch(PixelmonEntity entity) {
        return this.isDataMatch(entity.getPokemon());
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return pixelmon.hasFlag(this.value);
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        if (pixelmon.hasFlag(this.value)) {
            pixelmon.removeFlag(this.value);
        } else {
            pixelmon.addFlag(this.value);
        }
    }
}

