/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.requirement.AbstractPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class GenderRequirement
extends AbstractPokemonRequirement<Gender> {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"gender", "g"});
    private Gender gender;

    public GenderRequirement() {
        super(KEYS);
    }

    public GenderRequirement(Gender gender) {
        this();
        this.gender = gender;
    }

    @Override
    public ParseAttempt<List<Requirement<Pokemon, PixelmonEntity, ?>>> create(String key, String spec) {
        if (!spec.startsWith(key + ":")) {
            return ParseAttempt.error("No key found");
        }
        String[] args = spec.split(key + ":");
        if (args.length == 0) {
            return this.createInstance(Gender.MALE).map(Collections::singletonList);
        }
        return this.createInstance(Gender.valueOf(args[1].toUpperCase())).map(Collections::singletonList);
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, PixelmonEntity, Gender>> createInstance(Gender value) {
        return ParseAttempt.success(new GenderRequirement(value));
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return Objects.equals(pixelmon.getGender(), this.gender);
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        pixelmon.setGender(this.gender);
    }

    @Override
    public Gender getValue() {
        return this.gender;
    }
}

