/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.requirement.AbstractIntegerPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Map;
import java.util.Set;

public class EVsRequirement
extends AbstractIntegerPokemonRequirement {
    private static final Map<BattleStatsType, Set<String>> KEYS_BY_STAT = Maps.newHashMap();
    private static final int DEFAULT_VALUE = 0;
    private final BattleStatsType statType;

    public EVsRequirement(BattleStatsType statType) {
        super(KEYS_BY_STAT.get(statType), 0);
        this.statType = statType;
    }

    public EVsRequirement(BattleStatsType statType, int value) {
        super(KEYS_BY_STAT.get(statType), 0, value);
        this.statType = statType;
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, PixelmonEntity, Integer>> createInstance(Integer value) {
        return ParseAttempt.success(new EVsRequirement(this.statType, (int)value));
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return pixelmon.getStats().getEVs().getStat(this.statType) == this.value;
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        pixelmon.getStats().getEVs().setStat(this.statType, this.value);
    }

    static {
        KEYS_BY_STAT.put(BattleStatsType.HP, Sets.newHashSet((Object[])new String[]{"evhp", "hpev", "evshp"}));
        KEYS_BY_STAT.put(BattleStatsType.ATTACK, Sets.newHashSet((Object[])new String[]{"evattack", "evatk", "atkev", "attackev"}));
        KEYS_BY_STAT.put(BattleStatsType.DEFENSE, Sets.newHashSet((Object[])new String[]{"evdefence", "evdefense", "evdef", "defev", "defenseev", "defenceev"}));
        KEYS_BY_STAT.put(BattleStatsType.SPECIAL_ATTACK, Sets.newHashSet((Object[])new String[]{"evspecialattack", "evspatk", "spatkev", "specialattackev"}));
        KEYS_BY_STAT.put(BattleStatsType.SPECIAL_DEFENSE, Sets.newHashSet((Object[])new String[]{"evspecialdefence", "evspecialdefense", "evspdef", "spdefev", "specialdefenseev", "specialdefenceev"}));
        KEYS_BY_STAT.put(BattleStatsType.SPEED, Sets.newHashSet((Object[])new String[]{"evspeed", "evspd", "spdev", "speedev"}));
    }
}

