/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.requirement.AbstractIntegerPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.MewStats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Set;

public class CloneRequirement
extends AbstractIntegerPokemonRequirement {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"clone", "clones", "mewclones"});
    private static final int DEFAULT_VALUE = 0;

    public CloneRequirement() {
        super(KEYS, 0);
    }

    public CloneRequirement(int value) {
        super(KEYS, 0, value);
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, PixelmonEntity, Integer>> createInstance(Integer value) {
        return ParseAttempt.success(new CloneRequirement(value));
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        if (!pixelmon.getSpecies().is(PixelmonSpecies.MEW)) {
            return false;
        }
        MewStats stats = pixelmon.getExtraStats(MewStats.class).orElse(null);
        if (stats == null) {
            return false;
        }
        return stats.numCloned == this.value;
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        if (!pixelmon.getSpecies().is(PixelmonSpecies.MEW)) {
            return;
        }
        MewStats stats = pixelmon.getExtraStats(MewStats.class).orElse(null);
        if (stats == null) {
            return;
        }
        stats.numCloned = this.value;
    }
}

