/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.requirement.AbstractPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public abstract class AbstractBooleanPokemonRequirement
extends AbstractPokemonRequirement<Boolean> {
    private static final Set<String> FALSE_IDENTIFIERS = Sets.newHashSet((Object[])new String[]{"0", "false"});
    private static final Set<String> TRUE_IDENTIFIERS = Sets.newHashSet((Object[])new String[]{"1", "true"});
    protected boolean value;

    protected AbstractBooleanPokemonRequirement(Set<String> keys) {
        super(keys);
    }

    protected AbstractBooleanPokemonRequirement(Set<String> keys, boolean value) {
        super(keys);
        this.value = value;
    }

    @Override
    public boolean fits(String spec) {
        for (String subSpec : spec.split(" ")) {
            for (String key : this.keys) {
                if (!subSpec.startsWith(key + ":") && !subSpec.equalsIgnoreCase(key) && !subSpec.equalsIgnoreCase("!" + key) && !subSpec.startsWith("!" + key + ":")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ParseAttempt<List<Requirement<Pokemon, PixelmonEntity, ?>>> create(String spec) {
        for (String subSpec : spec.split(" ")) {
            for (String key : this.keys) {
                if (!subSpec.startsWith(key + ":") && !subSpec.equalsIgnoreCase(key) && !subSpec.equalsIgnoreCase("!" + key) && !subSpec.startsWith("!" + key + ":")) continue;
                return this.create(key, subSpec);
            }
        }
        return ParseAttempt.error("No matches found");
    }

    @Override
    public ParseAttempt<List<Requirement<Pokemon, PixelmonEntity, ?>>> create(String key, String spec) {
        if (spec.equalsIgnoreCase(key)) {
            return this.createInstance(true).map(Collections::singletonList);
        }
        if (!spec.contains(key + ":") && !spec.contains(key)) {
            return ParseAttempt.error("No key found!");
        }
        String[] args = spec.split(key + ":");
        boolean invert = args.length > 0 && args[0].startsWith("!") || spec.startsWith("!");
        boolean parsedValue = args.length == 1 || this.parseBoolean(args[1]);
        return this.createInstance(invert != parsedValue).map(Collections::singletonList);
    }

    protected boolean parseBoolean(String s) {
        if (s == null || FALSE_IDENTIFIERS.contains(s.toLowerCase(Locale.ROOT))) {
            return false;
        }
        return TRUE_IDENTIFIERS.contains(s.toLowerCase(Locale.ROOT));
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }
}

