/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.parsing;

import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class ParseAttempt<T> {
    private final T instance;
    private final String error;
    private final Throwable exception;

    protected ParseAttempt(T instance, String error, Throwable exception) {
        this.instance = instance;
        this.error = error;
        this.exception = exception;
    }

    @NotNull
    public T get() {
        if (!this.wasSuccess()) {
            if (this.wasExceptional()) {
                throw new NoSuchElementException("No value present as error was thrown:", this.exception);
            }
            if (this.wasError()) {
                throw new NoSuchElementException("No value present as spec failed to parse " + this.error);
            }
        }
        return this.instance;
    }

    public <A extends Throwable> T orThrow(A a) throws A {
        if (!this.wasSuccess()) {
            throw a;
        }
        return this.instance;
    }

    public <A extends Throwable> T orThrow(Supplier<A> a) throws A {
        if (!this.wasSuccess()) {
            throw (Throwable)a.get();
        }
        return this.instance;
    }

    @NotNull
    public String getError() {
        if (this.error == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.error;
    }

    @NotNull
    public Throwable getException() {
        if (this.exception == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.exception;
    }

    public boolean wasSuccess() {
        return this.instance != null;
    }

    public boolean wasError() {
        return !this.wasSuccess() && this.error != null;
    }

    public boolean wasExceptional() {
        return !this.wasSuccess() && this.exception != null;
    }

    public ParseAttempt<T> ifSuccessful(Consumer<T> consumer) {
        if (this.wasSuccess()) {
            consumer.accept(this.instance);
        }
        return this;
    }

    public ParseAttempt<T> ifFailure(Consumer<String> consumer) {
        if (this.wasError()) {
            consumer.accept(this.error);
        }
        return this;
    }

    public ParseAttempt<T> ifError(Consumer<Throwable> consumer) {
        if (this.wasExceptional()) {
            consumer.accept(this.exception);
        }
        return this;
    }

    public <A> ParseAttempt<A> map(Function<T, A> mapper) {
        if (this.wasExceptional()) {
            return ParseAttempt.exception(this.exception);
        }
        if (this.wasError()) {
            return ParseAttempt.error(this.error);
        }
        return ParseAttempt.success(mapper.apply(this.instance));
    }

    public static <B> ParseAttempt<B> success(B instance) {
        return new ParseAttempt<B>(instance, null, null);
    }

    public static <B> ParseAttempt<B> error(String error) {
        return new ParseAttempt<Object>(null, error, null);
    }

    public static <B> ParseAttempt<B> exception(Throwable exception) {
        return new ParseAttempt<Object>(null, null, exception);
    }
}

