/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.loader;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.pixelmonmod.pixelmon.tools.TriConsumer;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.AddReloadListenerEvent;
import org.apache.commons.lang3.StringUtils;

public class DatapackLoader {
    public static Builder builder(String context) {
        return new Builder(context);
    }

    public static class Builder {
        private final String context;
        private Gson gson = null;
        private String type = null;
        private TriConsumer<Gson, ResourceLocation, JsonElement> consumer = null;
        private final List<Runnable> preTasks = Lists.newArrayList();
        private final List<Runnable> postTasks = Lists.newArrayList();

        private Builder(String context) {
            this.context = context;
        }

        public Builder gson(Gson gson) {
            this.gson = gson;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder process(TriConsumer<Gson, ResourceLocation, JsonElement> consumer) {
            this.consumer = consumer;
            return this;
        }

        public Builder task(Runnable runnable) {
            if (this.consumer != null) {
                this.postTasks.add(runnable);
            } else {
                this.preTasks.add(runnable);
            }
            return this;
        }

        public void create(AddReloadListenerEvent event) {
            if (this.type == null || this.gson == null || this.consumer == null) {
                return;
            }
            event.addListener((PreparableReloadListener)new Impl(this.context, this.gson, this.type, this.consumer, this.preTasks, this.postTasks));
        }
    }

    private static class Impl
    extends SimpleJsonResourceReloadListener {
        private final String context;
        private final Gson gson;
        private final String type;
        private final TriConsumer<Gson, ResourceLocation, JsonElement> consumer;
        private final List<Runnable> preTasks;
        private final List<Runnable> postTasks;
        private final String name;

        public Impl(String context, Gson gson, String type, TriConsumer<Gson, ResourceLocation, JsonElement> consumer, List<Runnable> preTasks, List<Runnable> postTasks) {
            super(gson, type);
            this.context = context;
            this.gson = gson;
            this.type = type;
            this.consumer = consumer;
            this.preTasks = preTasks;
            this.postTasks = postTasks;
            this.name = StringUtils.capitalize((String)this.context) + StringUtils.capitalize((String)this.type) + "Manager";
        }

        protected void apply(Map<ResourceLocation, JsonElement> resources, ResourceManager manager, ProfilerFiller profiler) {
            for (Runnable runnable : this.preTasks) {
                runnable.run();
            }
            for (Map.Entry entry : resources.entrySet()) {
                this.consumer.accept(this.gson, (ResourceLocation)entry.getKey(), (JsonElement)entry.getValue());
            }
            for (Runnable runnable : this.postTasks) {
                runnable.run();
            }
        }

        public String m_7812_() {
            return this.name;
        }
    }
}

