/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pixelmonmod.api.EmptySpecification;
import com.pixelmonmod.api.Specification;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.Pixelmon;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;

public class SpecificationFactory {
    private static final Map<Class<? extends Specification<?, ?>>, SpecTypeData<?, ?, ?>> REGISTERED_REQUIREMENTS = Maps.newHashMap();

    private SpecificationFactory() {
        throw new UnsupportedOperationException("Static factory class");
    }

    public static <A, B, C extends Specification<A, B>> void register(Class<C> clazz, Requirement<A, B, ?> requirement) {
        SpecTypeData specTypeData = REGISTERED_REQUIREMENTS.computeIfAbsent(clazz, unused -> new SpecTypeData(clazz));
        specTypeData.getRequirements().add(requirement);
        specTypeData.getRequirements().sort(Comparator.comparing(o -> ((Requirement)o).getPriority()).reversed());
        for (String alias : requirement.getAliases()) {
            specTypeData.getRequirementNames().add(alias.trim());
        }
    }

    @NotNull
    public static <A, B, C extends Specification<A, B>> ParseAttempt<C> create(Class<? extends Specification<A, B>> clazz, String ... specs) {
        String spec = String.join((CharSequence)" ", specs);
        SpecTypeData<?, ?, ?> specTypeData = REGISTERED_REQUIREMENTS.get(clazz);
        if (specTypeData == null) {
            return ParseAttempt.error("Unknown data type");
        }
        ParseAttempt<List<Requirement<A, B, ?>>> requirements = SpecificationFactory.requirements(clazz, spec);
        if (requirements.wasExceptional()) {
            return ParseAttempt.exception(requirements.getException());
        }
        if (requirements.wasError()) {
            return ParseAttempt.error(requirements.getError());
        }
        List<Requirement<A, B, ?>> parsedRequirements = requirements.get();
        if (parsedRequirements.isEmpty()) {
            return ParseAttempt.error("No valid specs found in : " + spec);
        }
        try {
            Constructor<?> constructor = specTypeData.getConstructor();
            constructor.setAccessible(true);
            Specification createdSpec = (Specification)constructor.newInstance(spec, parsedRequirements);
            return ParseAttempt.success(createdSpec);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            return ParseAttempt.exception(e);
        }
    }

    public static <A, B> ParseAttempt<List<Requirement<A, B, ?>>> requirements(Class<? extends Specification<A, B>> specification, String spec) {
        if (!REGISTERED_REQUIREMENTS.containsKey(specification)) {
            return ParseAttempt.error("Unknown data type");
        }
        ArrayList requirements = Lists.newArrayList();
        SpecTypeData<?, ?, ?> specTypeData = REGISTERED_REQUIREMENTS.get(specification);
        for (Requirement<?, ?, ?> registeredRequirement : specTypeData.getRequirements()) {
            if (!registeredRequirement.fits(spec)) continue;
            ParseAttempt<List<Requirement<A, B, ?>>> requirementParseAttempt = registeredRequirement.create(spec);
            if (!requirementParseAttempt.wasSuccess()) {
                return requirementParseAttempt;
            }
            requirements.addAll((Collection)requirementParseAttempt.get());
            if (registeredRequirement.shouldContinue()) continue;
            break;
        }
        return ParseAttempt.success(requirements);
    }

    public static <A, B, C extends Specification<A, B>> C empty() {
        return (C)EmptySpecification.getInstance();
    }

    public static String[] getRequirementNames(Class<? extends Specification<?, ?>> clazz) {
        SpecTypeData<?, ?, ?> specTypeData = REGISTERED_REQUIREMENTS.get(clazz);
        if (specTypeData == null) {
            return new String[0];
        }
        return specTypeData.getRequirementNames().toArray(new String[0]);
    }

    public static <A, B, C extends Specification<A, B>> ParseAttempt<C> fromNbt(Class<? extends Specification<A, B>> clazz, CompoundTag nbt) {
        if (!nbt.m_128441_("SpecificationData")) {
            return SpecificationFactory.create(clazz, new String[0]);
        }
        return SpecificationFactory.create(clazz, nbt.m_128461_("SpecificationData"));
    }

    private static class SpecTypeData<C, A, B> {
        private final Constructor<C> constructor;
        private final List<Requirement<A, B, ?>> requirements = Lists.newArrayList();
        private final List<String> requirementNames = Lists.newArrayList();

        private SpecTypeData(Class<C> clazz) {
            this.constructor = this.findConstructor(clazz);
        }

        private Constructor<C> findConstructor(Class<C> clazz) {
            try {
                return clazz.getConstructor(String.class, List.class);
            }
            catch (NoSuchMethodException e) {
                Pixelmon.LOGGER.error("Couldn't construct " + clazz.getSimpleName() + " specification", (Throwable)e);
                return null;
            }
        }

        public Constructor<C> getConstructor() {
            return this.constructor;
        }

        public List<Requirement<A, B, ?>> getRequirements() {
            return this.requirements;
        }

        public List<String> getRequirementNames() {
            return this.requirementNames;
        }
    }
}

