/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pixelmonmod.api.Specification;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.Pixelmon;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import net.minecraft.nbt.CompoundTag;

public abstract class AbstractSpecification<A, B>
implements Specification<A, B> {
    protected final Class<A> dataType;
    protected final Class<B> minecraftType;
    protected final String originalSpec;
    protected final List<Requirement<A, B, ?>> requirements = Lists.newArrayList();

    protected AbstractSpecification(Class<A> dataType, Class<B> minecraftType, String originalSpec, List<Requirement<A, B, ?>> requirements) {
        this.dataType = dataType;
        this.minecraftType = minecraftType;
        this.originalSpec = originalSpec;
        this.requirements.addAll(requirements);
        this.requirements.sort(Comparator.comparing(o -> ((Requirement)o).getPriority()).reversed());
    }

    @Override
    public boolean matches(Object o) {
        if (o == null) {
            return false;
        }
        Class<Object> clazz = o.getClass();
        BiPredicate<Requirement, Object> predicate = null;
        if (clazz.isAssignableFrom(this.dataType)) {
            predicate = (abPokemonRequirement, o1) -> abPokemonRequirement.isDataMatch(o1);
        } else if (clazz.isAssignableFrom(this.minecraftType)) {
            predicate = (abPokemonRequirement, o1) -> abPokemonRequirement.isMinecraftMatch(o1);
        }
        if (predicate == null) {
            throw new IllegalArgumentException("Invalid object (" + o.getClass().getName() + ": " + o + ") was given to the 'matches' method for spec '" + this.originalSpec + "'");
        }
        for (Requirement<A, B, ?> requirement : this.requirements) {
            if (predicate.test(requirement, o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void apply(Object o) {
        if (o == null) {
            return;
        }
        Class<Object> clazz = o.getClass();
        BiConsumer<Requirement, Object> consumer = null;
        if (clazz.isAssignableFrom(this.dataType)) {
            consumer = (abPokemonRequirement, o1) -> abPokemonRequirement.applyData(o1);
        } else if (clazz.isAssignableFrom(this.minecraftType)) {
            consumer = (abPokemonRequirement, o1) -> abPokemonRequirement.applyMinecraft(o1);
        } else {
            Pixelmon.LOGGER.error("Invalid object was given to the apply method! Expected one of " + this.dataType.getName() + " or " + this.minecraftType.getName() + " but instead received " + clazz.getName());
            return;
        }
        for (Requirement<A, B, ?> requirement : this.requirements) {
            consumer.accept(requirement, o);
        }
    }

    @Override
    public <T> Optional<T> getValue(Class<? extends Requirement<A, B, T>> clazz) {
        return this.getRequirement(clazz).map(Requirement::getValue);
    }

    @Override
    public <T> Optional<Requirement<A, B, T>> getRequirement(Class<? extends Requirement<A, B, T>> clazz) {
        for (Requirement<A, B, ?> requirement : this.requirements) {
            if (!Objects.equals(requirement.getClass(), clazz)) continue;
            return Optional.of(requirement);
        }
        return Optional.empty();
    }

    @Override
    public <T> Set<Requirement<A, B, T>> getRequirements(Class<? extends Requirement<A, B, T>> clazz) {
        HashSet requirements = Sets.newHashSet();
        for (Requirement<A, B, ?> requirement : this.requirements) {
            if (!Objects.equals(requirement.getClass(), clazz)) continue;
            requirements.add(requirement);
        }
        return requirements;
    }

    @Override
    public CompoundTag write(CompoundTag nbt) {
        if (this.originalSpec == null) {
            return nbt;
        }
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        nbt.m_128359_("SpecificationData", this.originalSpec);
        return nbt;
    }

    public String toString() {
        return this.originalSpec;
    }
}

