/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network.tasks;

import java.io.IOException;
import java.nio.file.Files;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.network.NetworkInitialization;
import net.minecraftforge.network.config.ConfigurationTaskContext;
import net.minecraftforge.network.config.SimpleConfigurationTask;
import net.minecraftforge.network.packets.ConfigData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
class SyncConfigTask
extends SimpleConfigurationTask {
    static final ConfigurationTask.Type TYPE = new ConfigurationTask.Type("forge:sync_configs");
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker MARKER = MarkerManager.getMarker((String)"FORGE_SYNC_CONFIG");

    SyncConfigTask() {
        super(TYPE, SyncConfigTask::run);
    }

    private static void run(ConfigurationTaskContext ctx) {
        for (ModConfig cfg : (Set)ConfigTracker.INSTANCE.configSets().get(ModConfig.Type.SERVER)) {
            try {
                ConfigData pkt = new ConfigData(cfg.getFileName(), Files.readAllBytes(cfg.getFullPath()));
                NetworkInitialization.PLAY.send(pkt, ctx.getConnection());
            }
            catch (IOException e) {
                LOGGER.error(MARKER, "Failed to read config file {} terminating connection", (Object)cfg.getFileName(), (Object)e);
                ctx.getConnection().m_129507_((Component)Component.m_237113_((String)"Connection closed - Failed to read config on server"));
            }
        }
    }
}

