/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network.packets;

import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public record ModVersions(Map<String, Info> mods) {
    private static final int MAX_LENGTH = 256;

    public static ModVersions create() {
        return new ModVersions(ModList.get().getMods().stream().collect(Collectors.toMap(IModInfo::getModId, mod -> new Info(mod.getDisplayName(), mod.getVersion().toString()))));
    }

    public static ModVersions decode(FriendlyByteBuf buf) {
        return new ModVersions(buf.m_236847_(o -> o.m_130136_(256), o -> new Info(o.m_130136_(256), o.m_130136_(256))));
    }

    public void encode(FriendlyByteBuf output) {
        output.m_236831_(this.mods, (o, s) -> o.m_130072_(s, 256), (o, p) -> {
            o.m_130072_(p.name(), 256);
            o.m_130072_(p.version(), 256);
        });
    }

    public record Info(String name, String version) {
    }
}

