/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public record PacketDistributor<T>(BiFunction<PacketDistributor<T>, T, Consumer<Packet<?>>> functor, NetworkDirection direction) {
    public static final PacketDistributor<ServerPlayer> PLAYER = new PacketDistributor<ServerPlayer>(PacketDistributor::playerConsumer);
    public static final PacketDistributor<ResourceKey<Level>> DIMENSION = new PacketDistributor<ResourceKey>(PacketDistributor::playerListDimConsumer);
    public static final PacketDistributor<TargetPoint> NEAR = new PacketDistributor<TargetPoint>(PacketDistributor::playerListPointConsumer);
    public static final PacketDistributor<Void> ALL = new PacketDistributor<Void>(PacketDistributor::playerListAll);
    public static final PacketDistributor<Void> SERVER = new PacketDistributor<Void>(PacketDistributor::clientToServer, NetworkDirection.PLAY_TO_SERVER);
    public static final PacketDistributor<Entity> TRACKING_ENTITY = new PacketDistributor<Entity>(PacketDistributor::trackingEntity);
    public static final PacketDistributor<Entity> TRACKING_ENTITY_AND_SELF = new PacketDistributor<Entity>(PacketDistributor::trackingEntityAndSelf);
    public static final PacketDistributor<LevelChunk> TRACKING_CHUNK = new PacketDistributor<LevelChunk>(PacketDistributor::trackingChunk);
    public static final PacketDistributor<List<Connection>> NMLIST = new PacketDistributor<List>(PacketDistributor::networkManagerList);

    public PacketDistributor(BiFunction<PacketDistributor<T>, T, Consumer<Packet<?>>> functor) {
        this(functor, NetworkDirection.PLAY_TO_CLIENT);
    }

    public PacketTarget with(T input) {
        return new PacketTarget(this.functor.apply(this, (PacketDistributor)input), this.direction());
    }

    public PacketTarget noArg() {
        return new PacketTarget(this.functor.apply(this, null), this.direction());
    }

    private Consumer<Packet<?>> playerConsumer(ServerPlayer player) {
        return p -> player.f_8906_.getConnection().m_129512_(p);
    }

    private Consumer<Packet<?>> playerListDimConsumer(ResourceKey<Level> dimension) {
        return p -> this.getServer().m_6846_().m_11270_(p, dimension);
    }

    private Consumer<Packet<?>> playerListAll(Void ignored) {
        return p -> this.getServer().m_6846_().m_11268_(p);
    }

    private Consumer<Packet<?>> clientToServer(Void ignored) {
        return p -> Minecraft.m_91087_().m_91403_().m_295327_(p);
    }

    private Consumer<Packet<?>> playerListPointConsumer(TargetPoint tp) {
        return p -> this.getServer().m_6846_().m_11241_((Player)tp.excluded, tp.x, tp.y, tp.z, tp.r2, tp.dim, p);
    }

    private Consumer<Packet<?>> trackingEntity(Entity entity) {
        return p -> ((ServerChunkCache)entity.m_20193_().m_7726_()).m_8445_(entity, p);
    }

    private Consumer<Packet<?>> trackingEntityAndSelf(Entity entity) {
        return p -> ((ServerChunkCache)entity.m_20193_().m_7726_()).m_8394_(entity, p);
    }

    private Consumer<Packet<?>> trackingChunk(LevelChunk chunk) {
        return p -> ((ServerChunkCache)chunk.m_62953_().m_7726_()).f_8325_.m_183262_(chunk.m_7697_(), false).forEach(e -> e.f_8906_.m_141995_(p));
    }

    private Consumer<Packet<?>> networkManagerList(List<Connection> connections) {
        return p -> connections.forEach(nm -> nm.m_129512_(p));
    }

    private MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public record PacketTarget(Consumer<Packet<?>> packetConsumer, NetworkDirection direction) {
        public void send(Packet<?> packet) {
            this.packetConsumer.accept(packet);
        }
    }

    public record TargetPoint(@Nullable ServerPlayer excluded, double x, double y, double z, double r2, ResourceKey<Level> dim) {
        public TargetPoint(double x, double y, double z, double r2, ResourceKey<Level> dim) {
            this(null, x, y, z, r2, dim);
        }
    }
}

