/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting.ingredients;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.ingredients.AbstractIngredient;
import net.minecraftforge.common.crafting.ingredients.IIngredientSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompoundIngredient
extends AbstractIngredient {
    private List<Ingredient> children;
    private ItemStack[] stacks;
    private IntList itemIds;
    private final boolean isSimple;
    public static final Codec<CompoundIngredient> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Ingredient.f_290991_.listOf().fieldOf("children").forGetter(i -> i.children)).apply((Applicative)builder, CompoundIngredient::new));
    public static final IIngredientSerializer<CompoundIngredient> SERIALIZER = new IIngredientSerializer<CompoundIngredient>(){

        @Override
        public Codec<CompoundIngredient> codec() {
            return CODEC;
        }

        @Override
        public void write(FriendlyByteBuf buffer, CompoundIngredient value) {
            buffer.m_130130_(value.children.size());
            for (Ingredient child : value.children) {
                child.m_43923_(buffer);
            }
        }

        @Override
        public CompoundIngredient read(FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            ArrayList<Ingredient> children = new ArrayList<Ingredient>(size);
            for (int x = 0; x < size; ++x) {
                children.add(Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            return new CompoundIngredient(children);
        }
    };

    public static Ingredient of(Ingredient ... children) {
        if (children.length == 0) {
            throw new IllegalArgumentException("Cannot create a compound ingredient with no children, use Ingredient.of() to create an empty ingredient");
        }
        if (children.length == 1) {
            return children[0];
        }
        return new CompoundIngredient(Arrays.asList(children));
    }

    private CompoundIngredient(List<Ingredient> children) {
        this.children = Collections.unmodifiableList(children);
        this.isSimple = children.stream().allMatch(Ingredient::isSimple);
    }

    @NotNull
    public ItemStack[] m_43908_() {
        if (this.stacks == null) {
            ArrayList tmp = Lists.newArrayList();
            for (Ingredient child : this.children) {
                Collections.addAll(tmp, child.m_43908_());
            }
            this.stacks = tmp.toArray(new ItemStack[tmp.size()]);
        }
        return this.stacks;
    }

    @NotNull
    public IntList m_43931_() {
        boolean childrenNeedInvalidation = false;
        for (Ingredient child : this.children) {
            childrenNeedInvalidation |= child.checkInvalidation();
        }
        if (childrenNeedInvalidation || this.itemIds == null || this.checkInvalidation()) {
            this.markValid();
            this.itemIds = new IntArrayList();
            for (Ingredient child : this.children) {
                this.itemIds.addAll(child.m_43931_());
            }
            this.itemIds.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.itemIds;
    }

    public boolean test(@Nullable ItemStack target) {
        if (target == null) {
            return false;
        }
        return this.children.stream().anyMatch(c -> c.test(target));
    }

    @Override
    public boolean isSimple() {
        return this.isSimple;
    }

    public boolean m_43947_() {
        return this.children.stream().allMatch(Ingredient::m_43947_);
    }

    @Override
    public IIngredientSerializer<? extends Ingredient> serializer() {
        return SERIALIZER;
    }
}

