/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting;

import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SimpleCraftingContainer
implements CraftingContainer {
    private final int width;
    private final int height;
    private final NonNullList<ItemStack> items;

    public static Builder builder() {
        return new Builder();
    }

    public SimpleCraftingContainer(int width, int height) {
        this(width, height, (NonNullList<ItemStack>)NonNullList.m_122780_((int)(width * height), (Object)ItemStack.f_41583_));
    }

    public SimpleCraftingContainer(int width, int height, NonNullList<ItemStack> items) {
        this.width = width;
        this.height = height;
        this.items = items;
        if (items.size() != width * height) {
            throw new IllegalArgumentException("Invalid item list, must be same size inventory width * height, received " + items.size() + " expected " + width * height);
        }
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        return this.items.stream().noneMatch(p -> !p.m_41619_());
    }

    public ItemStack m_8020_(int slot) {
        return slot >= this.items.size() ? ItemStack.f_41583_ : (ItemStack)this.items.get(slot);
    }

    public ItemStack m_7407_(int slot, int count) {
        return ContainerHelper.m_18969_(this.items, (int)slot, (int)count);
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.items, (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.items.set(slot, (Object)stack);
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void m_5809_(StackedContents stacked) {
        this.items.forEach(arg_0 -> ((StackedContents)stacked).m_36466_(arg_0));
    }

    public int m_39347_() {
        return this.width;
    }

    public int m_39346_() {
        return this.height;
    }

    public List<ItemStack> m_280657_() {
        return List.copyOf(this.items);
    }

    public static class Builder {
        private final List<String> rows = new ArrayList<String>();
        private final Char2ObjectMap<ItemStack> keys = new Char2ObjectOpenHashMap();

        private Builder() {
            this.define(' ', ItemStack.f_41583_);
        }

        public Builder pattern(String row) {
            if (!this.rows.isEmpty() && row.length() != this.rows.get(0).length()) {
                throw new IllegalArgumentException("Pattern must be the same width on every line");
            }
            this.rows.add(row);
            return this;
        }

        public Builder pattern(String ... rows) {
            for (String row : rows) {
                this.pattern(row);
            }
            return this;
        }

        public Builder define(char key, ItemLike item) {
            return this.define(key, new ItemStack(item));
        }

        public Builder define(char key, ItemStack stack) {
            if (this.keys.containsKey(key)) {
                throw new IllegalArgumentException("key '" + key + "' is already defined.");
            }
            this.keys.put(key, (Object)stack);
            return this;
        }

        public SimpleCraftingContainer build() {
            CharArraySet unseen = new CharArraySet(this.keys.keySet());
            unseen.remove(' ');
            int height = this.rows.size();
            if (height == 0) {
                throw new IllegalStateException("Invalid builder, empty inventory");
            }
            int width = this.rows.get(0).length();
            NonNullList items = NonNullList.m_122780_((int)(width * height), (Object)ItemStack.f_41583_);
            int idx = 0;
            for (String row : this.rows) {
                for (int x = 0; x < width; ++x) {
                    char key = row.charAt(x);
                    ItemStack stack = (ItemStack)this.keys.get(key);
                    if (stack == null) {
                        throw new IllegalStateException("Invalid builder pattern, missing value for key '" + key + "'");
                    }
                    unseen.remove(key);
                    items.set(idx++, (Object)stack.m_41777_());
                }
            }
            if (!unseen.isEmpty()) {
                throw new IllegalStateException("Invalid builder, missing usage of defined keys: " + unseen);
            }
            return new SimpleCraftingContainer(width, height, (NonNullList<ItemStack>)items);
        }
    }
}

