vec3 filmic(filmic_settings f, vec3 color){
	vec3 filmic0 = (color * (f.a * color + f.b * f.c) + f.d * f.e);
	vec3 filmic1 = (color * (f.a * color + f.b) + f.d * f.f);

	return (filmic0 / filmic1) - f.e / f.f;
}

vec3 filmic(vec3 color){
	filmic_settings f = sfilmic();

	vec3 whiteScale = filmic(f, vec3(f.w));
	vec3 filmic = filmic(f, color) * 2.0;

	return linear_to_srgb(filmic * whiteScale);
}

vec3 lottes(vec3 x) {
    const vec3 a = vec3(1.6);
    const vec3 d = vec3(0.977);
    const vec3 hdrMax = vec3(8.0);
    const vec3 midIn = vec3(0.18);
    const vec3 midOut = vec3(0.267);

    const vec3 b = (-pow(midIn, a) + pow(hdrMax, a) * midOut) /
                   ((pow(hdrMax, a * d) - pow(midIn, a * d)) * midOut);

    const vec3 c = (pow(hdrMax, a * d) * pow(midIn, a) - pow(hdrMax, a) * pow(midIn, a * d) * midOut) /
                   ((pow(hdrMax, a * d) - pow(midIn, a * d)) * midOut);

    x *= 0.6;

    return linear_to_srgb(pow(x, a) / (pow(x, a * d) * b + c));
}

vec3 uchimura(vec3 x, float P, float a, float m, float l, float c, float b) {
    float l0 = ((P - m) * l) / a;
    float L0 = m - m / a;
    float L1 = m + (1.0 - m) / a;
    float S0 = m + l0;
    float S1 = m + a * l0;
    float C2 = (a * P) / (P - S1);
    float CP = -C2 / P;

    vec3 w0 = vec3(1.0 - smoothstep(0.0, m, x));
    vec3 w2 = vec3(step(m + l0, x));
    vec3 w1 = vec3(1.0 - w0 - w2);

    vec3 T = vec3(m * pow(x / m, vec3(c)) + b);
    vec3 S = vec3(P - (P - S1) * exp(CP * (x - S0)));
    vec3 L = vec3(m + a * (x - m));

    return T * w0 + L * w1 + S * w2;
}

vec3 uchimura(vec3 x) {
    const float P = 1.0;  // max display brightness
    const float a = 1.0;  // contrast
    const float m = 0.22; // linear section start
    const float l = 0.4;  // linear section length
    const float c = 1.33; // black
    const float b = 0.0;  // pedestal

    return linear_to_srgb(uchimura(x, P, a, m, l, c, b));
}

vec3 curve_tonemap(vec3 color){
    const float c = 4.0;

    color = pow(color, vec3(c));
    color = color / (color + 1.0);
    color = pow(color, vec3(1.0 / c));
    color = mix(color, curve(color), 0.2);
    color = linear_to_srgb(color);

    return color;
}

vec3 botw_tonemap(vec3 color){
    color = saturate(color);

    float lum = luminance(color);

    vec4 expm = 1.0 - exp(-vec4(color, lum));
    vec3 cpre = expm.w / lum * color;

    color = mix(cpre, expm.xyz, pow2(expm.w));
    
    float avg = (color.r + color.g + color.b) / 3.0;
    float maxc = max3(color);

    float w0 = 1.0 - pow2(1.0 - 2.0 * avg);
    float w1 = 1.0 + w0 * 0.21;

    color = mix(vec3(maxc), color, w1);
    color = linear_to_srgb(color);

    return color;
}