#if defined COMPOSITE13
    vec3 bloom_tiles(bloomSettings b, vec2 coord, float lod){
        float s_lod = exp2(lod);
        float s_tiles = exp2(-lod) * 1.5;

        vec2 s_scale = inverse_texel * s_lod;
        vec2 s_coord = (coord - s_tiles) * s_lod;

        if(any(greaterThanEqual(abs(s_coord - 0.5), s_scale + 0.5))) return vec3(0.0);

        vec3 bloom = vec3(0.0);
        float weight = 0.0;

        for(int i = -b.steps1; i <= b.steps1; i++){
            for(int j = -b.steps1; j <= b.steps1; j++){
                float s_length = length(vec2(i, j));
                float s_weight = filter_gaussian(s_length, 2.0);

                bloom += s_weight * texture2_lod(colortex8, s_coord + vec2(i, j) * s_scale, lod).xyz;
                weight += 2.0 * s_weight;
            }
        }

        return bloom / weight;
    }

    vec3 bloom(vec2 coord){
        bloomSettings b = s_bloom();

        vec3 bloom = vec3(0);

        #ifdef BLOOM
            for(int i = 1; i < b.steps0; i++){
                bloom += bloom_tiles(b, coord, i + 1.0);
            }
        #endif

        return bloom;
    }
#elif defined COMPOSITE14
    vec3 bloom_tiles(bloomSettings b, vec2 coord, float lod){
        float s_lod = exp2(lod);
        float s_tiles = s_lod * 1.5;

        return texture2(colortex2, (coord * s_lod) + s_tiles).xyz;
    }
    
    vec3 bloom(vec2 coord, vec3 color){
        bloomSettings b = s_bloom();
        exposure_settings e = exposure_s();

        vec3 bloom = vec3(0.0);
        float weight = 0.0;

        #ifdef BLOOM
            for(int i = 1; i < b.steps0; i++){
                float s_lod = -i - 1.0;
                float s_weight = 1.0 / (i + 1.2);

                bloom += bloom_tiles(b, coord, s_lod) * s_weight;
                weight += 2.0 * s_weight;
            }

            bloom /= weight;
            bloom = max0(bloom);

            #if EXPOSURE_TYPE == 0
                float average_exposure = texture2(colortex8, coord).w;
                      average_exposure = log2(average_exposure * 100.0 / 12.5);
                      average_exposure = 1.0 / (1.2 * exp2(average_exposure - e.offset));

                float average_bloom = exp2(average_exposure - 3.0 + b.strength);
            
                #ifdef UNDERWATER_BLOOM
                    average_bloom = isEyeInWater == 1 ? exp2(average_exposure - isEyeInWater * 0.16 + b.underwater_strength) : average_bloom;
                    average_bloom = isEyeInWater == 2 ? average_bloom : average_bloom;        
                #endif
            #elif EXPOSURE_TYPE == 1
                float average_bloom = 0.12 + b.strength;
        
                #ifdef UNDERWATER_BLOOM
                    average_bloom = isEyeInWater == 1 ? average_bloom + isEyeInWater * 0.7 + b.underwater_strength : average_bloom;
                    average_bloom = isEyeInWater == 2 ? average_bloom : average_bloom;        
                #endif
            #endif
            
            return mix(color, bloom, average_bloom);
        #else
            return color;
        #endif
    }
#endif
//Schiltigheim