vec3 rrt(aces_settings aces, vec3 color){
    float saturation = rgb_2_saturation( color);
    float ycIn = rgb_2_yc(color);
    float s = sigmoid_shaper((saturation - 0.4) / 0.2);
    float addedGlow = 1 + glow_fwd( ycIn, aces.rrt_glow_gain * s, aces.rrt_glow_mid);

    color *= addedGlow;

    float hue = rgb_2_hue(color);
    float centeredHue = center_hue(hue, aces.rrt_red_hue);
    float hueWeight = cubic_basis_shaper(centeredHue, aces.rrt_red_hue); hueWeight *= hueWeight;

    color.r += hueWeight * saturation * (aces.rrt_red_pivot - color.r) * (1 - aces.rrt_red_scale);

    color = saturate(color);
    
    vec3 colorPre = color * AP0_2_AP1_MAT;
         colorPre = clamp(colorPre, vec3(0), aces.half_max);
         colorPre = colorPre * calc_sat_adjust_matrix(aces.rrt_sat_factor, AP1_RGB2Y);
    
    vec3 rgbPost;

         rgbPost.r = segmented_spline_c5_fwd(colorPre.r, RRT_PARAMS);
         rgbPost.g = segmented_spline_c5_fwd(colorPre.g, RRT_PARAMS);
         rgbPost.b = segmented_spline_c5_fwd(colorPre.b, RRT_PARAMS);

    return rgbPost * AP1_2_AP0_MAT;
}