#if defined SHADERS_VERTEX
    out vec2 vertex_coord;

    void main(){
        vertex_coord = layout_texcoord.xy;
        gl_Position = vec4(layout_position.xy * 2.0 - 1.0, 0.0, 1.0);
    }
#elif defined SHADERS_FRAGMENT
    in vec2 vertex_coord;

    /* RENDERTARGETS:0 */
    layout (location = 0) out vec4 buffers0;

    #include "/program/shaders2/common/aces/aces.glsl"
    #include "/program/shaders2/common/tonemap.glsl"
    #include "/program/shaders2/common/color_correction.glsl"
    #include "/program/shaders2/common/bloom.glsl"
    #include "/program/shaders2/common/dof.glsl"

    vec3 tonemap(vec3 color){
        #if TONEMAP_TYPE == 0
            color = aces_tonemap(color);
        #elif TONEMAP_TYPE == 1
            color = filmic(color);
        #elif TONEMAP_TYPE == 2
            color = lottes(color);
        #elif TONEMAP_TYPE == 3
            color = uchimura(color);
        #elif TONEMAP_TYPE == 4
            color = curve_tonemap(color);
        #elif TONEMAP_TYPE == 5
            color = botw_tonemap(color);
        #endif
        
        return color;
    }

    vec3 desaturation(vec2 coord, vec3 color){
        float average_exposure = texture2(colortex8, coord).w;

        vec3 desaturation = luminance(color) * vec3(0.36333, 0.56333, 0.92333);
        vec3 desaturation_amt = exp2(-32.0 * desaturation * average_exposure);
        
        #if defined OVER_WORLD
            #if EXPOSURE_TYPE == 0
                return color * (1.0 - desaturation_amt) + pow(desaturation_amt * desaturation, vec3(0.8)) * vec3(0.36333, 0.56333, 0.92333);
            #elif EXPOSURE_TYPE == 1
                return color;
            #endif
        #else
            return color;
        #endif
    }

    vec3 rain(vec2 coord, vec3 color, vec3 bloom){
        #ifdef BLOOM
            return color + texture2(colortex14, coord).w * bloom * 1.2 * wetness;
        #else
            return color + texture2(colortex14, coord).w * 0.1 * wetness;
        #endif
    }

    void main(){
        vec3 color = depth_of_field(vertex_coord);
             color = bloom(vertex_coord, color);
             color = rain(vertex_coord, color, bloom(vertex_coord, color));
             color = desaturation(vertex_coord, color);
             color = tonemap(color);
             color = post_process(color);

        buffers0.xyz = color;
        buffers0.w = 1.0;
    }
#endif