const bool colortex7MipmapEnabled = true;

#if defined SHADERS_VERTEX
    out vec2 vertex_coord;
    out float exposure;

    void average_exposure(out float exposure){
        exposure_settings e = exposure_s();

        const float exposure_min = mix(2.0, 0.2, nightVision);
        const float exposure_max = 4300.0;

        float lod = log2(max2(texel));

        float current = luminance(pow2(texture2_lod(colortex7, vec2(0.5), lod).xyz));
              current = clamp(current, exposure_min, exposure_max);
              
        float previous = texture2(colortex8, vec2(0.5)).w;
              previous = previous > 0.0 ? previous : current;
              previous = clamp(previous, exposure_min, exposure_max);
        
        float exposure_time = current > previous ? e.speed_min : e.speed_max;
        float exposure_frame_time = exp(-exposure_time * frameTime);

        exposure = mix(current, previous, exposure_frame_time);
    }

    void main(){
        vertex_coord = layout_texcoord.xy;
        gl_Position = vec4(layout_position.xy * 2.0 - 1.0, 0.0, 1.0);

        average_exposure(exposure);
    }
#elif defined SHADERS_FRAGMENT
    in vec2 vertex_coord;
    in float exposure;

    /* RENDERTARGETS:7,8 */
    layout (location = 0) out vec3 buffers0;
    layout (location = 1) out vec4 buffers1;

    void main(){
        exposure_settings e = exposure_s();

        #if EXPOSURE_TYPE == 0
            float average_exposure = log2(exposure * 100.0 / 12.5);
                  average_exposure = 1.0 / (1.2 * exp2(average_exposure - e.offset));
        #elif EXPOSURE_TYPE == 1
            float average_exposure = log2(sqrt(e.aperture * 100.0) / (e.shutter_speed * e.iso));
                  average_exposure = 1.2 * exp2(average_exposure - e.offset);
        #endif

        vec3 color = pow2(texture2(colortex7, vertex_coord).xyz);

        buffers0 = color * average_exposure;

        buffers1.xyz = texture2(colortex8, vertex_coord).xyz;
        buffers1.w = exposure;
    }
#endif