#include "/program/shaders1/common/shadow/pcss.glsl"
#include "/program/shaders1/common/shadow/contact.glsl"

vec3 water_color(vec2 depth, float color){
    water_settings ws = water_s();

    float translucent_depth0 = (depth.x * 8.0 - 4.0) * shadowProjectionInverse[2].z + shadowProjectionInverse[3].z;
    float translucent_depth1 = (depth.y * 8.0 - 4.0) * shadowProjectionInverse[2].z + shadowProjectionInverse[3].z;

    float density = translucent_depth1 - translucent_depth0;
    float caustics_depth = saturate(density * 2.0);

    #ifdef WATER_CAUSTICS
        float caustics = color * 2.0 - 1.0;
              caustics = pow(caustics * 8.0, WATER_CAUSTICS_STRENGTH);
              caustics = caustics + caustics_depth * (1.0 - caustics_depth);
    #else
        float caustics = 1.0;
    #endif

    return exp2(ws.attenuation_coefficient * ws.density * density) * caustics;
    //return vec3(1.0);
}

vec3 soft_shadow(materials m, vec3 position, vec3 noise, float NdotL){
    shadow_settings s = shadow_s();

    vec3 shadow = vec3(0.0);
    vec3 shadow_position = world_to_shadowspace(position);
    vec3 shadow_out_position = shadow_distortion(s, shadow_position) * 0.5 + 0.5;

    NdotL = m.grass || m.leaves || m.fire || m.textured ? 0.5 : NdotL;

    if(any(greaterThanEqual(shadow_out_position, vec3(1.0))) || NdotL < 0.0001) return vec3(1.0);

    float bias = (2048.0 / s.resolution) + tan(acos(NdotL));
          bias = bias * distortion(s, shadow_position.xy) * 0.0005;

    vec2 radius = pcss(shadow_position, noise, bias);
    
    if(m.leaves){
        radius = vec2(0.0025);    
    }

    for(int i = 0; i < s.steps0; ++i){
        vec2 offset = sample_disk(i, noise.x, s.steps0);

        vec3 shadow_position0 = vec3(offset, -bias) * radius.x + shadow_position;
             shadow_position0 = shadow_distortion(s, shadow_position0) * 0.5 + 0.5;

        vec3 shadow_position1 = vec3(offset, -bias) * radius.y + shadow_position;
             shadow_position1 = shadow_distortion(s, shadow_position1) * 0.5 + 0.5;

        vec4 color0 = texture2(shadowcolor0, shadow_position0.xy);
        vec4 color1 = texture2(shadowcolor1, shadow_position1.xy);

        float depth0 = texture2(shadowtex0, shadow_position0.xy).x;
        float depth1 = texture2(shadowtex1, shadow_position1.xy).x;

        float shadow_depth0 = depth0 > shadow_position0.z - bias ? 1.0 : 0.0;
        float shadow_depth1 = depth1 > shadow_position1.z - bias ? 1.0 : 0.0;

        float ID = UnpackUnorm2x8(color1.w * 2.0 - 1.0).y * 255.0;

        bool water = condition(ID, 2);

        if(water){
            shadow += mix(vec3(shadow_depth0), water_color(vec2(depth0, depth1), color1.z), saturate(shadow_depth1 - shadow_depth0));
        } else {
            #ifdef COLORED_SHADOW
                shadow += mix(vec3(shadow_depth0), color0.xyz * (1.0 - color0.w), saturate(shadow_depth1 - shadow_depth0));
            #else
                shadow += vec3(shadow_depth1);
            #endif
        }
    }

    return shadow / float(s.steps0);
}

vec3 hard_shadow(materials m, vec3 position, float NdotL){
    shadow_settings s = shadow_s();

    vec3 shadow = vec3(0.0);
    vec3 shadow_position = world_to_shadowspace(position);
    vec3 shadow_out_position = shadow_distortion(s, shadow_position) * 0.5 + 0.5;

    NdotL = m.grass || m.leaves || m.fire || m.textured ? 0.5 : NdotL;

    if(any(greaterThanEqual(shadow_out_position, vec3(1.0))) || NdotL < 0.0001) return vec3(1.0);

    float bias = (2048.0 / s.resolution) + tan(acos(NdotL));
          bias = bias * distortion(s, shadow_position.xy) * 0.0005;

    shadow_position = shadow_distortion(s, shadow_position) * 0.5 + 0.5;

    vec4 color0 = texture2(shadowcolor0, shadow_position.xy);
    vec4 color1 = texture2(shadowcolor1, shadow_position.xy);

    float depth0 = texture2(shadowtex0, shadow_position.xy).x;
    float depth1 = texture2(shadowtex1, shadow_position.xy).x;

    //bias = (depth0 == depth1) ? (dot(shadow_normal, s_normal) > 0.1 ? bias : bias * 0.5) : bias;

    float shadow_depth0 = depth0 > shadow_position.z - bias ? 1.0 : 0.0;
    float shadow_depth1 = depth1 > shadow_position.z - bias ? 1.0 : 0.0;

    float ID = UnpackUnorm2x8(color1.w * 2.0 - 1.0).y * 255.0;

    bool water = condition(ID, 2);

    if(water){
        shadow += mix(vec3(shadow_depth0), water_color(vec2(depth0, depth1), color1.z), saturate(shadow_depth1 - shadow_depth0));
    } else {
        #ifdef COLORED_SHADOW
            shadow += mix(vec3(shadow_depth0), color0.xyz * srgb_to_linear(1.0 - color0.w), saturate(shadow_depth1 - shadow_depth0));
        #else
            shadow += vec3(shadow_depth1);
        #endif
    }

    return NdotL < 0.0001 ? vec3(1.0) : shadow;
}