float screenspace_contact_shadow(materials m, vec3 view_position, vec3 position, vec3 direction, float noise){
    shadow_settings s = shadow_s();

    #if defined DEFERRED9
        if(m.grass){
            s.strength = 0.65;
            s.z_depth = 0.05;
        }
    #endif

    direction = abs(-position.z) * direction;
    direction = normalize(view_to_screenspace(direction + position) - view_position);

    vec3 s_increment = direction * (s.z_depth / s.steps3);
    vec3 s_position = view_position + s_increment * (noise + 1.0);

    float depth = texture2(depthtex1, s_position.xy).x;

    float shadow = 1.0;

    #ifdef SCREEN_SPACE_SHADOW
        for(int i = 0; i < s.steps3; i++, s_position += s_increment){
            if(saturate(s_position) != s_position) break;

            depth = texture2(depthtex1, s_position.xy).x;

            if(depth < s_position.z){
                float depth0 = linear_depth(s_position.z);
                float depth1 = linear_depth(depth);

                float dist = abs(depth1 - depth0) / depth1;

                if(dist < s.z_depth && depth0 > -far){
                    shadow *= 1.0 - s.strength;
                }
            }
        }
    #endif
        
    return shadow;   
}