#if defined SHADERS_VERTEX
    void vertex_skylight(){
        const int steps = 12;

        skylight0 = mat3(0.0);
        skylight1 = mat3(0.0);

        for(int i = 0; i < steps; i++){
            vec2 offset = vec2(i + 0.5) / steps;
            vec3 direction = generate_unit_vector(offset);

            vec3 skylight = texture2(colortex1, project_sphere(direction)).xyz;
                 skylight = skylight + skylight.g * mix(0.4, 2.0, wetness);
                 //skylight = mix(skylight, vec3(luminance(skylight)) * 2.0, wetness * 0.9);

            skylight0[0] += skylight * saturate(direction.x);
            skylight0[1] += skylight * saturate(direction.y);
            skylight0[2] += skylight * saturate(direction.z);

            skylight1[0] += skylight * saturate(-direction.x);
            skylight1[1] += skylight * saturate(-direction.y);
            skylight1[2] += skylight * saturate(-direction.z);
        }

        const float inverse_steps = 4.0 * pi / float(steps);
        
        skylight0[0] *= inverse_steps;
        skylight0[1] *= inverse_steps;
        skylight0[2] *= inverse_steps;

        skylight1[0] *= inverse_steps;
        skylight1[1] *= inverse_steps;
        skylight1[2] *= inverse_steps;
    }
#elif defined SHADERS_FRAGMENT
    vec3 skylight(vec3 normal, float clouds_shadow){
        normal = normal / dot(abs(normal), vec3(1.0));

        vec3 n = skylight0[0] * saturate(normal.x) + 
                 skylight0[1] * saturate(normal.y) +
                 skylight0[2] * saturate(normal.z) +
                 skylight1[0] * saturate(-normal.x) +
                 skylight1[1] * saturate(-normal.y) +
                 skylight1[2] * saturate(-normal.z);

        #if defined OVER_WORLD
            return n * (1.0 + SHADOW_BRIGHTNESS);
        #else
            return vec3(0.0);
        #endif
    }
#endif