float ssao(vec3 position, vec3 normal, vec2 noise){
    const int steps = AO_QUALITY;

    const float radius = 0.05 * -position.z;
    const float z_depth = 0.05 * -position.z;

    float occlusion = 1.0;

    for(int i = 0; i < steps; ++i){
        vec2 offset = (i / steps) + noise;
        vec3 direction = generate_cone_vector(normal, offset, 90.0);

        vec3 ray_increment = direction * radius + position;
        vec3 ray_position = view_to_screenspace(ray_increment);

        float depth = texture2(depthtex1, ray_position.xy).x;

        vec3 sample_position = screen_to_viewspace(vec3(ray_position.xy, depth));
        vec3 sample_vector = normalize(sample_position - position);

        float depth0 = linear_depth(ray_increment.z);
        float depth1 = linear_depth(sample_position.z);

        float s_depth = depth1 - depth0; 

        if(s_depth < z_depth && depth0 > 0.0){
            occlusion += 1.25 * saturate(dot(sample_vector, normal));
        }
    }

    occlusion /= float(steps);
    occlusion = pow2(1.0 - occlusion);

    return max0(occlusion);
}

#include "/program/shaders1/common/specular/raytrace.glsl"

float rtao(vec3 view_position, vec3 position, vec3 normal, vec3 vector, vec2 noise){
    const int steps0 = 2;
    const int steps1 = 64;

    const float z_depth = 0.07;

    float occlusion = 1.0;
    vec3 hit_position = vec3(0.0);

    float NdotV = max(1e-7, dot(normal, -vector));

    for(int i = 0; i < steps0; i++){
        vec3 ray_direction = generate_cone_vector(normal, noise, 90.0);
        
        bool intersect = screenspace_raytrace(view_position, position, mat3(gbufferModelView) * ray_direction, NdotV, noise.y, z_depth, steps1, hit_position);

        if(!intersect){
            float NdotL = dot(normal, ray_direction);
            if(NdotL <= 0.0) continue;

            occlusion += saturate(NdotL);
        }   
    }

    occlusion /= float(steps0);
    occlusion = pow2(occlusion);

    return occlusion;
}