vec3 planet(vec3 position, inout vec3 transmittance){
    atmosphere_constant ac = atmosphere_s();

    const float delta = 0.005;
    const float radius = 58232e3;
    const float dist = 1243.53e7;
    const float angular_radius = 2.0 * radius / dist;
    const float roughness = 0.343;

    vec3 light_direction = mat3(gbufferModelViewInverse) * normalize(shadowLightPosition);
    vec3 sun_direction = mat3(gbufferModelViewInverse) * normalize(sunPosition);

    vec3 planet_position = normalize(vec3(-0.5, 0.7, -0.6));
         planet_position = planet_position * rotation_mat(vec3(1.0, 0.0, 0.0), sun_direction);

    vec3 view_position = vec3(0.0, angular_radius, 0.0);
    vec2 sphere = ray_sphere_intersection(-planet_position, position, angular_radius);

    transmittance = sphere.y > 0.0 ? vec3(0.0) : transmittance;

    vec3 normal = normalize(position * sphere.x - planet_position);

    float n0 = perlin_fbm(vec3(normal.x + delta, normal.y, normal.z), 5);
    float n1 = perlin_fbm(vec3(normal.x, normal.y + delta, normal.z), 5);
    float n2 = perlin_fbm(vec3(normal.x, normal.y, normal.z + delta), 5);

    normal = normalize(vec3(normal.x * n0, normal.y * n1, normal.z * n2));

    float NdotL = dot(normal, sun_direction);
    float NdotV = dot(normal, -position);
    float LdotV = length(sun_direction - position);
    float NdotH = (NdotL + NdotV) * inversesqrt(2.0 + 2.0 * LdotV);

    vec3 pos = vec3(normal.x * 0.7, normal.y * 0.2, normal.z * 0.4) * 1.5;
    float noise = perlin_fbm(pos, 6);

    vec3 color0 = vec3(0.101961,0.619608,0.666667) * 0.5;
    vec3 color1 = vec3(0.666667,0.666667,0.498039);
    vec3 color2 = vec3(0.666667,1,1);

    vec3 albedo = mix(color0, color1, pow6(1.0 - noise * 0.5 + 0.4));
         albedo = mix(albedo, color2, pow2(1.0 - noise * 0.5 + 0.2));
         albedo = srgb_to_linear(albedo);

    vec3 diffuse = saturate(NdotL) * hammon_diffuse(albedo, NdotL, NdotV, NdotH, LdotV, pow2(roughness));
    vec3 sunlight = temperature_to_rgb(5778.0) * ac.sun_luminance * (sunAngle < 0.5 ? 1.0 : 0.1);

    return sphere.y < 0.0 ? vec3(0.0) : albedo * diffuse * sunlight + albedo;  
}