#if defined GBUFFERS
    struct waves_settings{
        int steps0;
        int steps1;
        int steps2;

        float parallax_height;
        float phase;
        float speed;
        float mult;
        float scale;
        float delta;
    };
    
    waves_settings swaves(){
        waves_settings ws;

        ws.steps0 = 14;
        ws.steps1 = 10;
        ws.steps2 = 32;

        ws.parallax_height = 2.7;
        ws.delta = 0.1;
        
        #if WAVES_PRESET == 0
            ws.phase = 4.0 * (1.0 + WAVES_FREQUENCY);
            ws.speed = 1.4 * (1.0 + WAVES_SPEED);
            ws.mult  = 0.2 * (1.0 + WAVES_HEIGHT);
            ws.scale = 0.25 * (1.0 + WAVES_SCALE);
        #elif WAVES_PRESET == 1
            ws.phase = 2.0 * (1.0 + WAVES_FREQUENCY);
            ws.speed = 1.6 * (1.0 + WAVES_SPEED);
            ws.mult  = 0.055 * (1.0 + WAVES_HEIGHT);
            ws.scale = 2.1 * (1.0 + WAVES_SCALE);
        #elif WAVES_PRESET == 2
            ws.phase = 4.0 * (1.0 + WAVES_FREQUENCY);
            ws.speed = 0.9 * (1.0 + WAVES_SPEED);
            ws.mult  = 1.4 * (1.0 + WAVES_HEIGHT);
            ws.scale = 0.06 * (1.0 + WAVES_SCALE);
        #endif
        
        return ws;
    }
#endif